/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class BeltTunnelItem extends Internal.BlockItem {
        constructor(p_i48527_1_: Internal.Block_, p_i48527_2_: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BeltTunnelItem_ = BeltTunnelItem;
    interface BooleanPredicate extends Internal.Predicate<boolean> {
        and(arg0: Internal.BooleanPredicate_): this;
        /**
         * @deprecated
        */
        test(arg0: any): boolean;
        not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        negate(): Internal.Predicate<any>;
        /**
         * @deprecated
        */
        test(arg0: boolean): boolean;
        abstract test(arg0: boolean): boolean;
        or(arg0: Internal.BooleanPredicate_): this;
        negation(): this;
        /**
         * @deprecated
        */
        and(arg0: Internal.Predicate_<boolean>): Internal.Predicate<boolean>;
        identity(): this;
        isEqual<T>(arg0: any): Internal.Predicate<T>;
        /**
         * @deprecated
        */
        or(arg0: Internal.Predicate_<boolean>): Internal.Predicate<boolean>;
        (arg0: boolean): boolean;
    }
    type BooleanPredicate_ = BooleanPredicate;
    class MoltenBronzeFluid extends Internal.MoltenMetalFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenBronzeFluid_ = MoltenBronzeFluid;
    class WhistleBlock$WhistleSize extends Internal.Enum<Internal.WhistleBlock$WhistleSize> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.WhistleBlock$WhistleSize;
        static values(): Internal.WhistleBlock$WhistleSize[];
        get serializedName(): string
        static readonly LARGE: Internal.WhistleBlock$WhistleSize;
        static readonly SMALL: Internal.WhistleBlock$WhistleSize;
        static readonly MEDIUM: Internal.WhistleBlock$WhistleSize;
    }
    type WhistleBlock$WhistleSize_ = WhistleBlock$WhistleSize | "medium" | "large" | "small";
    class EntityIota extends Internal.Iota {
        constructor(e: Internal.Entity_)
        getEntity(): Internal.Entity;
        toleratesOther(that: Internal.Iota_): boolean;
        get entity(): Internal.Entity
        static TYPE: Internal.EntityIota$1;
    }
    type EntityIota_ = EntityIota;
    /**
     * @deprecated
    */
    class CountOnEveryLayerPlacement extends Internal.PlacementModifier {
        static of($$0: Internal.IntProvider_): Internal.CountOnEveryLayerPlacement;
        static of($$0: number): Internal.CountOnEveryLayerPlacement;
        static readonly CODEC: Internal.Codec<Internal.CountOnEveryLayerPlacement>;
    }
    type CountOnEveryLayerPlacement_ = CountOnEveryLayerPlacement;
    class RoseQuartzLampBlock extends Internal.Block implements Internal.WeakPowerCheckingBlock, com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly POWERING: Internal.BooleanProperty;
        static readonly ACTIVATE: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type RoseQuartzLampBlock_ = RoseQuartzLampBlock;
    class SelectionScrollInput extends Internal.ScrollInput {
        constructor(xIn: number, yIn: number, widthIn: number, heightIn: number)
        charTyped($$0: string, $$1: number): boolean;
        static of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        moveTo(x: number, y: number): void;
        remove(): void;
        isInBoundingBox(x: number, y: number): boolean;
        hasParent(): boolean;
        fullSize(): Internal.Size;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        mouseMoved($$0: number, $$1: number): void;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        forOptions(options: Internal.List_<net.minecraft.network.chat.Component>): Internal.ScrollInput;
        setPosition($$0: number, $$1: number): void;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        static of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        getCurrentFocusPath(): Internal.ComponentPath;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        root(): Internal.ParentComponent;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        get currentFocusPath(): Internal.ComponentPath
    }
    type SelectionScrollInput_ = SelectionScrollInput;
    class ComputerState extends Internal.Enum<Internal.ComputerState> implements Internal.StringRepresentable {
        static values(): Internal.ComputerState[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        getTexture(): string;
        static valueOf(name: string): Internal.ComputerState;
        get serializedName(): string
        get texture(): string
        static readonly BLINKING: Internal.ComputerState;
        static readonly ON: Internal.ComputerState;
        static readonly OFF: Internal.ComputerState;
    }
    type ComputerState_ = "on" | ComputerState | "blinking" | "off";
    class BlockCrystalFixer extends Internal.BlockBaseGui<Internal.TileCrystalFixer> {
        constructor()
        openGui(tile: Internal.TileCrystalFixer_, p: Internal.Player_): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockCrystalFixer_ = BlockCrystalFixer;
    interface SodiumWorldRendererAccessor {
        abstract invokeRenderBlockEntities(arg0: Internal.PoseStack_, arg1: Internal.RenderBuffers_, arg2: Internal.Long2ObjectMap_<Internal.SortedSet<Internal.BlockDestructionProgress>>, arg3: number, arg4: Internal.MultiBufferSource$BufferSource_, arg5: number, arg6: number, arg7: number, arg8: Internal.BlockEntityRenderDispatcher_): void;
        abstract invokeRenderGlobalBlockEntities(arg0: Internal.PoseStack_, arg1: Internal.RenderBuffers_, arg2: Internal.Long2ObjectMap_<Internal.SortedSet<Internal.BlockDestructionProgress>>, arg3: number, arg4: Internal.MultiBufferSource$BufferSource_, arg5: number, arg6: number, arg7: number, arg8: Internal.BlockEntityRenderDispatcher_): void;
    }
    type SodiumWorldRendererAccessor_ = SodiumWorldRendererAccessor;
    class BlockExMolecularAssembler extends Internal.BlockBaseGui<Internal.TileExMolecularAssembler> {
        constructor()
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        openGui(tile: Internal.TileExMolecularAssembler_, p: Internal.Player_): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockExMolecularAssembler_ = BlockExMolecularAssembler;
    abstract class LootPoolEntryContainer implements Internal.ComposableEntryContainer, Internal.LootPoolEntryAccessor {
        and($$0: Internal.ComposableEntryContainer_): Internal.ComposableEntryContainer;
        getConditions(): Internal.LootItemCondition[];
        or($$0: Internal.ComposableEntryContainer_): Internal.ComposableEntryContainer;
        abstract expand(arg0: Internal.LootContext_, arg1: Internal.Consumer_<Internal.LootPoolEntry>): boolean;
        abstract getType(): Internal.LootPoolEntryType;
        validate($$0: Internal.ValidationContext_): void;
        get conditions(): Internal.LootItemCondition[]
        get type(): Internal.LootPoolEntryType
        readonly conditions: Internal.LootItemCondition[];
    }
    type LootPoolEntryContainer_ = LootPoolEntryContainer;
    interface IMixinRedstoneWireBlock {
        abstract litematicaGetPlacementState(arg0: Internal.BlockGetter_, arg1: Internal.BlockState_, arg2: BlockPos_): Internal.BlockState;
        (arg0: Internal.BlockGetter, arg1: Internal.BlockState, arg2: BlockPos): Internal.BlockState_;
    }
    type IMixinRedstoneWireBlock_ = IMixinRedstoneWireBlock;
    class CastResult {
        constructor(cast: Internal.Iota_, continuation: Internal.SpellContinuation_, newData: Internal.CastingImage_, sideEffects: Internal.List_<Internal.OperatorSideEffect>, resolutionType: Internal.ResolvedPatternType_, sound: Internal.EvalSound_)
        component2(): Internal.SpellContinuation;
        getNewData(): Internal.CastingImage;
        getContinuation(): Internal.SpellContinuation;
        getCast(): Internal.Iota;
        getSideEffects(): Internal.List<Internal.OperatorSideEffect>;
        component3(): Internal.CastingImage;
        component6(): Internal.EvalSound;
        getResolutionType(): Internal.ResolvedPatternType;
        copy(cast: Internal.Iota_, continuation: Internal.SpellContinuation_, newData: Internal.CastingImage_, sideEffects: Internal.List_<Internal.OperatorSideEffect>, resolutionType: Internal.ResolvedPatternType_, sound: Internal.EvalSound_): this;
        component1(): Internal.Iota;
        component4(): Internal.List<Internal.OperatorSideEffect>;
        component5(): Internal.ResolvedPatternType;
        static copy$default(arg0: Internal.CastResult_, arg1: Internal.Iota_, arg2: Internal.SpellContinuation_, arg3: Internal.CastingImage_, arg4: Internal.List_<any>, arg5: Internal.ResolvedPatternType_, arg6: Internal.EvalSound_, arg7: number, arg8: any): Internal.CastResult;
        getSound(): Internal.EvalSound;
        get newData(): Internal.CastingImage
        get continuation(): Internal.SpellContinuation
        get cast(): Internal.Iota
        get sideEffects(): Internal.List<Internal.OperatorSideEffect>
        get resolutionType(): Internal.ResolvedPatternType
        get sound(): Internal.EvalSound
    }
    type CastResult_ = CastResult;
    class OriginCaveWorldCarver extends Internal.CaveWorldCarver {
        constructor(p_i231917_1_: Internal.Codec_<Internal.CaveCarverConfiguration>)
    }
    type OriginCaveWorldCarver_ = OriginCaveWorldCarver;
    class LecternMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: net.minecraft.world.Container_, $$2: Internal.ContainerData_)
        constructor($$0: number)
        getBook(): Internal.ItemStack;
        getPage(): number;
        get book(): Internal.ItemStack
        get page(): number
        static readonly BUTTON_NEXT_PAGE: 2;
        static readonly BUTTON_PREV_PAGE: 1;
        static readonly BUTTON_TAKE_BOOK: 3;
        static readonly BUTTON_PAGE_JUMP_RANGE_START: 100;
    }
    type LecternMenu_ = LecternMenu;
    interface Boolean2CharFunction extends it.unimi.dsi.fastutil.Function<boolean, string> {
        remove(arg0: boolean): string;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Boolean2FloatFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2CharFunction<T>;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2CharFunction;
        defaultReturnValue(): string;
        getOrDefault(arg0: boolean, arg1: string): string;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Boolean2ByteFunction;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Boolean2DoubleFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2CharFunction;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Boolean2LongFunction;
        abstract get(arg0: boolean): string;
        defaultReturnValue(arg0: string): void;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2CharFunction;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2CharFunction<T>;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: string): string;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Boolean2ObjectFunction<T>;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, string>;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2CharFunction;
        apply(arg0: boolean): string;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2CharFunction;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Boolean2IntFunction;
        containsKey(arg0: boolean): boolean;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2CharFunction;
        put(arg0: boolean, arg1: string): string;
        size(): number;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Boolean2ReferenceFunction<T>;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Boolean2ShortFunction;
        clear(): void;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<boolean, T>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2CharFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        (arg0: boolean): string;
    }
    type Boolean2CharFunction_ = Boolean2CharFunction;
    interface IModifiableDisplay extends Internal.ITinkerStationDisplay, Internal.IModifiable {
        getLocalizedName(): net.minecraft.network.chat.Component;
        abstract getRenderTool(): Internal.ItemStack;
        emi(amount: number): Internal.EmiStack;
        setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: Internal.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        abstract getToolDefinition(): Internal.ToolDefinition;
        abstract asItem(): Internal.Item;
        getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        getAttributeModifiers(tool: Internal.IToolStackView_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        emi(): Internal.EmiStack;
        /**
         * @deprecated
        */
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: slimeknights.tconstruct.library.utils.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        get localizedName(): net.minecraft.network.chat.Component
        get renderTool(): Internal.ItemStack
        get toolDefinition(): Internal.ToolDefinition
    }
    type IModifiableDisplay_ = IModifiableDisplay;
    interface TransactionContext$OuterCloseCallback {
        abstract afterOuterClose(arg0: Internal.TransactionContext$Result_): void;
        (arg0: Internal.TransactionContext$Result): void;
    }
    type TransactionContext$OuterCloseCallback_ = TransactionContext$OuterCloseCallback;
    class ClientboundPlayerCombatEndPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.CombatTracker_)
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundPlayerCombatEndPacket_ = ClientboundPlayerCombatEndPacket;
    interface StorageView <T> {
        abstract getAmount(): number;
        abstract isResourceBlank(): boolean;
        abstract getResource(): T;
        getUnderlyingView(): this;
        abstract extract(arg0: T, arg1: number, arg2: Internal.TransactionContext_): number;
        abstract getCapacity(): number;
        get amount(): number
        get resourceBlank(): boolean
        get resource(): T
        get underlyingView(): Internal.StorageView<T>
        get capacity(): number
    }
    type StorageView_<T> = StorageView<T>;
    abstract class AbstractSmokeStackBlock <T extends Internal.SmartBlockEntity> extends Internal.Block implements Internal.ProperWaterloggedBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<T> {
        constructor(properties: Internal.BlockBehaviour$Properties_, shape: any_, variant: string)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<T, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): T;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<T>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        abstract getBlockEntityClass(): T;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<T>;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        abstract getBlockEntityType(): Internal.BlockEntityType<T>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityClass(): T
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<T>
        static readonly ENABLED: Internal.BooleanProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly STYLE: Internal.EnumProperty<Internal.SmokestackStyle>;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type AbstractSmokeStackBlock_<T extends Internal.SmartBlockEntity> = AbstractSmokeStackBlock<T>;
    interface ExplosionHooksImpl$ExplosionExtensions {
        abstract architectury_getPosition(): Vec3d;
        (): Vec3d_;
    }
    type ExplosionHooksImpl$ExplosionExtensions_ = ExplosionHooksImpl$ExplosionExtensions;
    class MapItem extends Internal.ComplexItem {
        constructor($$0: Internal.Item$Properties_)
        static getMapId($$0: Internal.ItemStack_): number;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static getSavedData($$0: number, $$1: Internal.Level_): Internal.MapItemSavedData;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getColor($$0: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static getSavedData($$0: Internal.ItemStack_, $$1: Internal.Level_): Internal.MapItemSavedData;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        static lockMap($$0: Internal.Level_, $$1: Internal.ItemStack_): void;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static makeKey($$0: number): string;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static renderBiomePreviewMap($$0: Internal.ServerLevel_, $$1: Internal.ItemStack_): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static create($$0: Internal.Level_, $$1: number, $$2: number, $$3: number, $$4: boolean, $$5: boolean): Internal.ItemStack;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        update($$0: Internal.Level_, $$1: Internal.Entity_, $$2: Internal.MapItemSavedData_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly IMAGE_WIDTH: 128;
        static readonly IMAGE_HEIGHT: 128;
        static readonly MAP_SCALE_TAG: "map_scale_direction";
        static readonly MAP_LOCK_TAG: "map_to_lock";
    }
    type MapItem_ = MapItem;
    class ColorConfig extends Internal.ConfigValue<Internal.Color4I> {
        constructor()
        withAlphaEditing(): this;
        isAllowAlphaEdit(): boolean;
        getStringForGUI(v: Internal.Color4I_): net.minecraft.network.chat.Component;
        get allowAlphaEdit(): boolean
    }
    type ColorConfig_ = ColorConfig;
    interface FunctionContainer {
        enchantWithLevels(levels: Internal.NumberProvider_, treasure: boolean): this;
        abstract addFunction(arg0: Internal.JsonObject_): this;
        enchantRandomly(enchantments: ResourceLocation_[]): this;
        furnaceSmelt(): this;
        lootingEnchant(count: Internal.NumberProvider_, limit: number): this;
        addConditionalFunction(func: Internal.Consumer_<Internal.ConditionalFunction>): this;
        name(name: net.minecraft.network.chat.Component_, entity: Internal.LootContext$EntityTarget_): this;
        damage(damage: Internal.NumberProvider_): this;
        nbt(tag: Internal.CompoundTag_): this;
        count(count: Internal.NumberProvider_): this;
        copyName(source: Internal.CopyNameFunction$NameSource_): this;
        lootTable(table: ResourceLocation_, seed: number): this;
        name(name: net.minecraft.network.chat.Component_): this;
        (arg0: Internal.JsonObject): this;
    }
    type FunctionContainer_ = FunctionContainer;
    interface MultiNoiseBiomeSourceParameterList$Preset$SourceProvider {
        abstract apply<T>(arg0: Internal.Function_<Internal.ResourceKey<Internal.Biome>, T>): Internal.Climate$ParameterList<T>;
        (arg0: Internal.Function<Internal.ResourceKey<Internal.Biome>, T>): Internal.Climate$ParameterList_<T>;
    }
    type MultiNoiseBiomeSourceParameterList$Preset$SourceProvider_ = MultiNoiseBiomeSourceParameterList$Preset$SourceProvider;
    class ChunkMap$TrackedEntity implements Internal.EntityTrackerAccessor {
        constructor(arg0: Internal.ChunkMap_, arg1: Internal.Entity_, arg2: number, arg3: number, arg4: boolean)
        getPlayersTracking(): Internal.Set<any>;
        updatePlayer($$0: Internal.ServerPlayer_): void;
        broadcastAndSend($$0: Internal.Packet_<any>): void;
        removePlayer($$0: Internal.ServerPlayer_): void;
        broadcastRemoved(): void;
        localvar$gnp000$railways$securitycraft$modifyFlag(original: boolean): boolean;
        broadcast($$0: Internal.Packet_<any>): void;
        updatePlayers($$0: Internal.List_<Internal.ServerPlayer>): void;
        get playersTracking(): Internal.Set<any>
        readonly entity: Internal.Entity;
    }
    type ChunkMap$TrackedEntity_ = ChunkMap$TrackedEntity;
    class WrittenBookItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static resolveBookComponents($$0: Internal.ItemStack_, $$1: Internal.CommandSourceStack_, $$2: Internal.Player_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        static getPageCount($$0: Internal.ItemStack_): number;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getGeneration($$0: Internal.ItemStack_): number;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static makeSureTagIsValid($$0: Internal.CompoundTag_): boolean;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly PAGE_LENGTH: 32767;
        static readonly TITLE_LENGTH: 16;
        static readonly TAG_RESOLVED: "resolved";
        static readonly TAG_GENERATION: "generation";
        static readonly MAX_GENERATION: 2;
        static readonly TAG_FILTERED_TITLE: "filtered_title";
        static readonly TAG_TITLE: "title";
        static readonly TAG_AUTHOR: "author";
        static readonly MAX_PAGES: 100;
        static readonly TITLE_MAX_LENGTH: 32;
        static readonly TAG_PAGES: "pages";
        static readonly TAG_FILTERED_PAGES: "filtered_pages";
        static readonly PAGE_EDIT_LENGTH: 1024;
    }
    type WrittenBookItem_ = WrittenBookItem;
    class Snowball extends Internal.ThrowableItemProjectile {
        constructor($$0: Internal.Level_, $$1: Internal.LivingEntity_)
        constructor($$0: Internal.EntityType_<Internal.Snowball>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type Snowball_ = Snowball;
    class Zoglin extends Internal.Monster implements Internal.Enemy, Internal.HoglinBase {
        constructor($$0: Internal.EntityType_<Internal.Zoglin>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        static throwTarget($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_): void;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getBrain(): Internal.Brain<Internal.Zoglin>;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        static hurtAndThrowTarget($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        isAdult(): boolean;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getAttackAnimationRemainingTicks(): number;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get brain(): Internal.Brain<Internal.Zoglin>
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get adult(): boolean
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get attackAnimationRemainingTicks(): number
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Zoglin_ = Zoglin;
    interface Constable {
        abstract describeConstable(): Internal.Optional<Internal.ConstantDesc>;
        (): Internal.Optional_<Internal.ConstantDesc>;
    }
    type Constable_ = Constable;
    interface SymbolScriptable {
        abstract has(arg0: Internal.Context_, arg1: Internal.Symbol_, arg2: Internal.Scriptable_): boolean;
        abstract "delete"(arg0: Internal.Context_, arg1: Internal.Symbol_): void;
        abstract get(arg0: Internal.Context_, arg1: Internal.Symbol_, arg2: Internal.Scriptable_): any;
        abstract put(arg0: Internal.Context_, arg1: Internal.Symbol_, arg2: Internal.Scriptable_, arg3: any): void;
    }
    type SymbolScriptable_ = SymbolScriptable;
    interface ModifyRecipeResultCallback {
        abstract modify(arg0: Internal.ModifyRecipeCraftingGrid_, arg1: Internal.ItemStack_): Internal.ItemStack;
        (arg0: Internal.ModifyRecipeCraftingGrid, arg1: Internal.ItemStack): Internal.ItemStack_;
    }
    type ModifyRecipeResultCallback_ = ModifyRecipeResultCallback;
    class RollerBlock extends Internal.AttachedActorBlock implements Internal.IBE<Internal.RollerBlockEntity> {
        constructor(p_i48377_1_: Internal.BlockBehaviour$Properties_)
        getBlockEntityType(): Internal.BlockEntityType<Internal.RollerBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.RollerBlockEntity>): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.RollerBlockEntity>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.RollerBlockEntity;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockEntityClass(): typeof Internal.RollerBlockEntity;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.RollerBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.RollerBlockEntity>
        get blockEntityClass(): typeof Internal.RollerBlockEntity
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type RollerBlock_ = RollerBlock;
    class ToolSwapperUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.ToolSwapperUpgradeWrapper, Internal.ToolSwapperUpgradeItem> implements Internal.IBlockClickResponseUpgrade, Internal.IEntityToolSwapUpgrade, Internal.IAttackEntityResponseUpgrade, Internal.IBlockToolSwapUpgrade {
        onBlockInteract(world: Internal.Level_, pos: BlockPos_, blockState: Internal.BlockState_, player: Internal.Player_): boolean;
        canProcessBlockInteract(): boolean;
        canProcessEntityInteract(): boolean;
        getFilterLogic(): Internal.FilterLogic;
        onEntityInteract(world: Internal.Level_, entity: Internal.Entity_, player: Internal.Player_): boolean;
        setToolSwapMode(toolSwapMode: Internal.ToolSwapMode_): void;
        canBeDisabled(): boolean;
        setSwapWeapon(shouldSwapWeapon: boolean): void;
        onBlockClick(player: Internal.Player_, pos: BlockPos_): boolean;
        getToolSwapMode(): Internal.ToolSwapMode;
        onAdded(): void;
        shouldSwapWeapon(): boolean;
        onAttackEntity(player: Internal.Player_): boolean;
        onBeforeRemoved(): void;
        get filterLogic(): Internal.FilterLogic
        set toolSwapMode(toolSwapMode: Internal.ToolSwapMode_)
        set swapWeapon(shouldSwapWeapon: boolean)
        get toolSwapMode(): Internal.ToolSwapMode
    }
    type ToolSwapperUpgradeWrapper_ = ToolSwapperUpgradeWrapper;
    class ServerboundChatPacket extends Internal.Record implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: string, $$1: Internal.Instant_, $$2: number, $$3: Internal.MessageSignature_, $$4: Internal.LastSeenMessages$Update_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        message(): string;
        signature(): Internal.MessageSignature;
        write($$0: Internal.FriendlyByteBuf_): void;
        timeStamp(): Internal.Instant;
        handle($$0: Internal.ServerGamePacketListener_): void;
        salt(): number;
        lastSeenMessages(): Internal.LastSeenMessages$Update;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ServerboundChatPacket_ = ServerboundChatPacket;
    interface DisplayInfoFTBL {
        abstract getIconStackFTBL(): Internal.ItemStack;
        get iconStackFTBL(): Internal.ItemStack
        (): Internal.ItemStack_;
    }
    type DisplayInfoFTBL_ = DisplayInfoFTBL;
    class Lazy <T> implements Internal.Supplier<T> {
        static serviceLoader<T>(type: T): Internal.Lazy<T>;
        forget(): void;
        static of<T>(supplier: Internal.Supplier_<T>, expiresInMs: number): Internal.Lazy<T>;
        get(): T;
        static of<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    }
    type Lazy_<T> = Lazy<T>;
    class PixieVillageStructure extends Internal.Structure {
        static readonly CODEC: Internal.Codec<Internal.PixieVillageStructure>;
    }
    type PixieVillageStructure_ = PixieVillageStructure;
    class StyleConstants$ParagraphConstants extends Internal.StyleConstants implements Internal.AttributeSet$ParagraphAttribute {
    }
    type StyleConstants$ParagraphConstants_ = StyleConstants$ParagraphConstants;
    class AnimatableManager$ControllerRegistrar {
        constructor()
        add(...controllers: Internal.AnimationController_<any>[]): this;
        remove(name: string): this;
    }
    type AnimatableManager$ControllerRegistrar_ = AnimatableManager$ControllerRegistrar;
    class RiceBlock extends Internal.BushBlock implements Internal.LiquidBlockContainer, Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        canPlaceLiquid(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, fluidIn: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess(level: Internal.Level_, rand: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(level: Internal.ServerLevel_, rand: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        withAge(age: number): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(level: Internal.LevelReader_, pos: BlockPos_, state: Internal.BlockState_, isClient: boolean): boolean;
        setLightEmission(v: number): void;
        isMaxAge(state: Internal.BlockState_): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_, fluidStateIn: Internal.FluidState_): boolean;
        getAgeProperty(): Internal.IntegerProperty;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        isSupportingRiceUpper(topState: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        getMaxAge(): number;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get ageProperty(): Internal.IntegerProperty
        get maxAge(): number
        static readonly AGE: Internal.IntegerProperty;
        static readonly SUPPORTING: Internal.BooleanProperty;
    }
    type RiceBlock_ = RiceBlock;
    class SmallToadstoolFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type SmallToadstoolFeature_ = SmallToadstoolFeature;
    class CreativeEnergyBlockEntity extends Internal.CrateBlockEntity implements Internal.EnergyTransferable {
        constructor(tileEntityTypeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getCachedEnergy(side: Internal.Direction_): Internal.EnergyStorage;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setCache(side: Internal.Direction_, storage: Internal.EnergyStorage_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        firstTick(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        updateCache(): void;
        getEnergyStorage(direction: Internal.Direction_): Internal.EnergyStorage;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
    }
    type CreativeEnergyBlockEntity_ = CreativeEnergyBlockEntity;
    class SettingsFrom extends Internal.Enum<Internal.SettingsFrom> {
        static valueOf(name: string): Internal.SettingsFrom;
        static values(): Internal.SettingsFrom[];
        static readonly DISMANTLE_ITEM: Internal.SettingsFrom;
        static readonly MEMORY_CARD: Internal.SettingsFrom;
    }
    type SettingsFrom_ = SettingsFrom | "dismantle_item" | "memory_card";
    interface OwoClientConnectionExtension {
        abstract owo$getChannelSet(): Internal.Set<ResourceLocation>;
        abstract owo$setChannelSet(arg0: Internal.Set_<ResourceLocation>): void;
    }
    type OwoClientConnectionExtension_ = OwoClientConnectionExtension;
    class Products$P13 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function13_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R>>): Internal.App<F, R>;
    }
    type Products$P13_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> = Products$P13<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>;
    class Products$P14 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>, arg13: Internal.App_<F, T14>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R>>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function14_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R>): Internal.App<F, R>;
    }
    type Products$P14_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> = Products$P14<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>;
    class SpatialStorageCellItem extends Internal.AEBaseItem implements Internal.ISpatialStorageCell {
        constructor(props: Internal.Item$Properties_, spatialScale: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getMaxStoredDim(is: Internal.ItemStack_): number;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        setStoredDimension(is: Internal.ItemStack_, plotId: number, size: BlockPos_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        getAllocatedPlotId(is: Internal.ItemStack_): number;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        isSpatialStorage(is: Internal.ItemStack_): boolean;
        doSpatialTransition(is: Internal.ItemStack_, level: Internal.ServerLevel_, min: BlockPos_, max: BlockPos_, playerId: number): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SpatialStorageCellItem_ = SpatialStorageCellItem;
    class Products$P11 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function11_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R>>): Internal.App<F, R>;
    }
    type Products$P11_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> = Products$P11<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>;
    class Products$P12 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function12_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R>): Internal.App<F, R>;
    }
    type Products$P12_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> = Products$P12<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>;
    interface LidBlockEntity {
        abstract getOpenNess(arg0: number): number;
        (arg0: number): number;
    }
    type LidBlockEntity_ = LidBlockEntity;
    class Products$P10 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R>>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function10_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R>): Internal.App<F, R>;
    }
    type Products$P10_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> = Products$P10<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>;
    interface ScoreHolderArgument$Result {
        abstract getNames(arg0: Internal.CommandSourceStack_, arg1: Internal.Supplier_<Internal.Collection<string>>): Internal.Collection<string>;
        (arg0: Internal.CommandSourceStack, arg1: Internal.Supplier<Internal.Collection<string>>): Internal.Collection_<string>;
    }
    type ScoreHolderArgument$Result_ = ScoreHolderArgument$Result;
    class PackagerBlockEntity extends Internal.SmartBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        scheduleStockCheck(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        activate(): void;
        getRenderedBox(): Internal.ItemStack;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAvailableItems(): Internal.InventorySummary;
        unwrapBox(box: Internal.ItemStack_, ctx: Internal.TransactionContext_): boolean;
        onLoad(): void;
        getItemStorage(side: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        recheckIfLinksPresent(): void;
        flashLink(): void;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        isTooBusyFor(type: Internal.LogisticallyLinkedBehaviour$RequestType_): boolean;
        getTrayOffset(partialTicks: number): number;
        triggerStockCheck(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        updateSignAddress(): void;
        attemptToSend(queuedRequests: Internal.List_<Internal.PackagingRequest>): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getAvailableItems(scanInputSlots: boolean): Internal.InventorySummary;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        isTargetingSameInventory(inventory: Internal.IdentifiedInventory_): boolean;
        redstoneModeActive(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get renderedBox(): Internal.ItemStack
        get availableItems(): Internal.InventorySummary
        get infiniteBoundingBox(): Internal.AABB
        buttonCooldown: number;
        inventory: Internal.PackagerItemHandler;
        redstonePowered: boolean;
        animationTicks: number;
        signBasedAddress: string;
        queuedExitingPackages: Internal.List<Internal.BigItemStack>;
        static readonly CYCLE: 20;
        previouslyUnwrapped: Internal.ItemStack;
        computerBehaviour: Internal.AbstractComputerBehaviour;
        hasCustomComputerAddress: boolean;
        customComputerAddress: string;
        targetInventory: Internal.InvManipulationBehaviour;
        heldBox: Internal.ItemStack;
        animationInward: boolean;
    }
    type PackagerBlockEntity_ = PackagerBlockEntity;
    class Pack$Position extends Internal.Enum<Internal.Pack$Position> {
        opposite(): this;
        insert<T>($$0: Internal.List_<T>, $$1: T, $$2: Internal.Function_<T, Internal.Pack>, $$3: boolean): number;
        static values(): Internal.Pack$Position[];
        static valueOf($$0: string): Internal.Pack$Position;
        static readonly TOP: Internal.Pack$Position;
        static readonly BOTTOM: Internal.Pack$Position;
    }
    type Pack$Position_ = Pack$Position | "bottom" | "top";
    class RenderedBlockItem extends Internal.BlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RenderedBlockItem_ = RenderedBlockItem;
    class Products$P15 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>, arg13: Internal.App_<F, T14>, arg14: Internal.App_<F, T15>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function15_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R>>): Internal.App<F, R>;
    }
    type Products$P15_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> = Products$P15<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>;
    interface CustomDamageHandler {
        abstract damage(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.LivingEntity_, arg3: Internal.Consumer_<Internal.LivingEntity>): number;
        (arg0: Internal.ItemStack, arg1: number, arg2: Internal.LivingEntity, arg3: Internal.Consumer<Internal.LivingEntity>): number;
    }
    type CustomDamageHandler_ = CustomDamageHandler;
    class CreativeCellItem extends Internal.AEBaseItem implements Internal.ICellWorkbenchItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getConfigInventory(is: Internal.ItemStack_): Internal.ConfigInventory;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        static ofItems(...items: Internal.ItemLike_[]): Internal.ItemStack;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static ofFluids(...fluids: Internal.Fluid_[]): Internal.ItemStack;
        setFuzzyMode(is: Internal.ItemStack_, fzMode: Internal.FuzzyMode_): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getFuzzyMode(is: Internal.ItemStack_): Internal.FuzzyMode;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getUpgrades(stack: Internal.ItemStack_): Internal.IUpgradeInventory;
        emi(amount: number): Internal.EmiStack;
        isEditable(is: Internal.ItemStack_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CreativeCellItem_ = CreativeCellItem;
    class LegSolver$Leg {
        constructor(forward: number, side: number, range: number, isWing: boolean)
        update(entity: Internal.EntityDragonBase_, sideX: number, sideZ: number, forwardX: number, forwardZ: number, scale: number): void;
        getHeight(delta: number): number;
        readonly side: number;
        readonly forward: number;
    }
    type LegSolver$Leg_ = LegSolver$Leg;
    class Products$P16 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>, arg9: Internal.App_<F, T10>, arg10: Internal.App_<F, T11>, arg11: Internal.App_<F, T12>, arg12: Internal.App_<F, T13>, arg13: Internal.App_<F, T14>, arg14: Internal.App_<F, T15>, arg15: Internal.App_<F, T16>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function16_<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R>>): Internal.App<F, R>;
    }
    type Products$P16_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> = Products$P16<F, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>;
    class PrintoutItem extends Internal.Item {
        constructor(settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static getColours(stack: Internal.ItemStack_): string[];
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static createMultipleFromTitleAndText(title: string, text: string[], colours: string[]): Internal.ItemStack;
        static createSingleFromTitleAndText(title: string, text: string[], colours: string[]): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static getTitle(stack: Internal.ItemStack_): string;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        static getText(stack: Internal.ItemStack_): string[];
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        static createBookFromTitleAndText(title: string, text: string[], colours: string[]): Internal.ItemStack;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        static getPageCount(stack: Internal.ItemStack_): number;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly LINES_PER_PAGE: 21;
        static readonly LINE_MAX_LENGTH: 25;
        static readonly MAX_PAGES: 16;
    }
    type PrintoutItem_ = PrintoutItem;
    abstract class BlockStateProvider {
        constructor()
        static simple($$0: Internal.BlockState_): Internal.SimpleStateProvider;
        abstract getState(arg0: Internal.RandomSource_, arg1: BlockPos_): Internal.BlockState;
        static simple($$0: Internal.Block_): Internal.SimpleStateProvider;
        static readonly CODEC: Internal.Codec<Internal.BlockStateProvider>;
    }
    type BlockStateProvider_ = BlockStateProvider;
    class FlavorEvent extends Internal.EventObject {
        constructor(arg0: Internal.Clipboard_)
    }
    type FlavorEvent_ = FlavorEvent;
    class MoveControl implements Internal.Control {
        constructor($$0: Internal.Mob_)
        setWantedPosition($$0: number, $$1: number, $$2: number, $$3: number): void;
        getWantedX(): number;
        getWantedY(): number;
        getWantedZ(): number;
        strafe($$0: number, $$1: number): void;
        getSpeedModifier(): number;
        tick(): void;
        hasWanted(): boolean;
        get wantedX(): number
        get wantedY(): number
        get wantedZ(): number
        get speedModifier(): number
        static readonly MIN_SPEED: 5.0E-4;
        static readonly MIN_SPEED_SQR: 2.5000003E-7;
    }
    type MoveControl_ = MoveControl;
    class LogisticallyLinkedBehaviour$RequestType extends Internal.Enum<Internal.LogisticallyLinkedBehaviour$RequestType> {
        static values(): Internal.LogisticallyLinkedBehaviour$RequestType[];
        static valueOf(name: string): Internal.LogisticallyLinkedBehaviour$RequestType;
        static readonly RESTOCK: Internal.LogisticallyLinkedBehaviour$RequestType;
        static readonly REDSTONE: Internal.LogisticallyLinkedBehaviour$RequestType;
        static readonly PLAYER: Internal.LogisticallyLinkedBehaviour$RequestType;
    }
    type LogisticallyLinkedBehaviour$RequestType_ = LogisticallyLinkedBehaviour$RequestType | "player" | "restock" | "redstone";
    interface Builder <R, T extends R, P, S extends Internal.Builder<R, T, P, S>> extends Internal.NonNullSupplier<Internal.RegistryEntry<T>> {
        abstract getRegistryKey(): Internal.ResourceKey<Internal.Registry<R>>;
        onRegister(callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): S;
        of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        transform<R2, T2 extends R2, P2, S2 extends Internal.Builder<R2, T2, P2, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<S, S2>): S2;
        addMiscData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<D>): S;
        abstract getParent(): P;
        abstract getOwner(): Internal.AbstractRegistrate<any>;
        setData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: Internal.NonNullBiConsumer_<Internal.DataGenContext<R, T>, D>): S;
        lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<Internal.RegistryEntry<T>>;
        abstract asSupplier(): Internal.NonNullSupplier<T>;
        onRegisterAfter<OR>(dependencyType: Internal.ResourceKey_<Internal.Registry<OR>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): S;
        abstract getName(): string;
        abstract register(): Internal.RegistryEntry<T>;
        getEntry(): T;
        get(): Internal.RegistryEntry<T>;
        build(): P;
        get registryKey(): Internal.ResourceKey<Internal.Registry<R>>
        get parent(): P
        get owner(): Internal.AbstractRegistrate<any>
        get name(): string
        get entry(): T
    }
    type Builder_<R, T extends R, P, S extends Internal.Builder<R, T, P, S>> = Builder<R, T, P, S>;
    abstract class AbstractBogeyBlockEntity extends Internal.CachedRenderBBBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        animate(distanceMoved: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getBogeyData(): Internal.CompoundTag;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getStyle(): Internal.BogeyStyle;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        abstract getDefaultStyle(): Internal.BogeyStyle;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getVirtualAngle(partialTicks: number): number;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setBogeyStyle(style: Internal.BogeyStyle_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setBogeyData(newData: Internal.CompoundTag_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get bogeyData(): Internal.CompoundTag
        get style(): Internal.BogeyStyle
        get defaultStyle(): Internal.BogeyStyle
        get infiniteBoundingBox(): Internal.AABB
        set bogeyStyle(style: Internal.BogeyStyle_)
        set bogeyData(newData: Internal.CompoundTag_)
        static readonly BOGEY_DATA_KEY: "BogeyData";
        static readonly BOGEY_STYLE_KEY: "BogeyStyle";
    }
    type AbstractBogeyBlockEntity_ = AbstractBogeyBlockEntity;
    abstract class SingleStackStorage extends Internal.SnapshotParticipant<Internal.ItemStack> implements Internal.SingleSlotStorage<Internal.ItemVariant> {
        constructor()
        getResource(): any;
        extract(variant: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        getSlot(slot: number): Internal.SingleSlotStorage<Internal.ItemVariant>;
        supportsInsertion(): boolean;
        getUnderlyingView(): Internal.StorageView<Internal.ItemVariant>;
        supportsExtraction(): boolean;
        extract(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getAmount(): number;
        isResourceBlank(): boolean;
        getSlotCount(): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        insert(insertedVariant: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static asClass<T>(): Internal.Storage<T>;
        insert(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        getCapacity(): number;
        get resource(): any
        get underlyingView(): Internal.StorageView<Internal.ItemVariant>
        get amount(): number
        get resourceBlank(): boolean
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        get version(): number
        get capacity(): number
    }
    type SingleStackStorage_ = SingleStackStorage;
    class WideGaugeBogeyBlock extends Internal.CRBogeyBlock {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        static create(large: boolean): com.tterrag.registrate.util.nullness.NonNullFunction<Internal.BlockBehaviour$Properties, Internal.WideGaugeBogeyBlock>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type WideGaugeBogeyBlock_ = WideGaugeBogeyBlock;
    class CustomShapelessRecipe extends Internal.ShapelessRecipe {
        constructor(id: ResourceLocation_, recipe: Internal.ShapelessRecipeSpec_)
        isSpecial(): boolean;
        toSpec(): Internal.ShapelessRecipeSpec;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        static validatingSerialiser<T extends Internal.CustomShapelessRecipe>(factory: Internal.CustomShapelessRecipe$Factory_<Internal.DataResult<T>>): Internal.RecipeSerializer<T>;
        static serialiser<T extends Internal.CustomShapelessRecipe>(factory: Internal.CustomShapelessRecipe$Factory_<T>): Internal.RecipeSerializer<T>;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getSerializer(): Internal.RecipeSerializer<Internal.CustomShapelessRecipe>;
        getMod(): string;
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get serializer(): Internal.RecipeSerializer<Internal.CustomShapelessRecipe>
        get mod(): string
    }
    type CustomShapelessRecipe_ = CustomShapelessRecipe;
    class BushBlock extends Internal.Block implements Internal.IPlantable {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getPlant(world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        mayPlaceOn($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BushBlock_ = BushBlock;
    abstract class UnmodifiableConfigWrapper <C extends Internal.UnmodifiableConfig> implements Internal.UnmodifiableConfig {
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getOrElse<T>(arg0: string, arg1: T): T;
        getLong(arg0: string): number;
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getInt(arg0: Internal.List_<string>): number;
        getByteOrElse(arg0: string, arg1: number): number;
        getShortOrElse(arg0: string, arg1: number): number;
        get<T>(arg0: Internal.List_<string>): T;
        getCharOrElse(arg0: string, arg1: string): string;
        contains(arg0: string): boolean;
        getShort(arg0: Internal.List_<string>): number;
        getShortOrElse(arg0: Internal.List_<string>, arg1: number): number;
        isNull(arg0: Internal.List_<string>): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getRaw<T>(arg0: Internal.List_<string>): T;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: Internal.Supplier_<T>): T;
        getOptionalLong(arg0: string): Internal.OptionalLong;
        getOptional<T>(arg0: Internal.List_<string>): Internal.Optional<T>;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getOptional<T>(arg0: string): Internal.Optional<T>;
        getShort(arg0: string): number;
        getOrElse<T>(arg0: string, arg1: Internal.Supplier_<T>): T;
        entrySet(): Internal.Set<Internal.UnmodifiableConfig$Entry>;
        getChar(arg0: string): string;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalLong(arg0: Internal.List_<string>): Internal.OptionalLong;
        getChar(arg0: Internal.List_<string>): string;
        contains(arg0: Internal.List_<string>): boolean;
        get<T>(arg0: string): T;
        getLong(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        apply<T>(arg0: Internal.List_<string>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: Internal.LongSupplier_): number;
        getInt(arg0: string): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: number): number;
        isEmpty(): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: Internal.IntSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getRaw<T>(arg0: string): T;
        getIntOrElse(arg0: string, arg1: Internal.IntSupplier_): number;
        isNull(arg0: string): boolean;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): Internal.Optional<T>;
        getCharOrElse(arg0: Internal.List_<string>, arg1: string): string;
        getByte(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): Internal.Optional<T>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getByteOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getLongOrElse(arg0: string, arg1: number): number;
        getOptionalInt(arg0: string): Internal.OptionalInt;
        getLongOrElse(arg0: string, arg1: Internal.LongSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: Internal.Supplier_<T>): T;
        getByte(arg0: string): number;
        getIntOrElse(arg0: string, arg1: number): number;
        getOptionalInt(arg0: Internal.List_<string>): Internal.OptionalInt;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        configFormat(): Internal.ConfigFormat<any>;
        size(): number;
        valueMap(): Internal.Map<string, any>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: Internal.Supplier_<T>): T;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        apply<T>(arg0: string): T;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        get empty(): boolean
    }
    type UnmodifiableConfigWrapper_<C extends Internal.UnmodifiableConfig> = UnmodifiableConfigWrapper<C>;
    class Chicken extends Internal.Animal {
        constructor($$0: Internal.EntityType_<Internal.Chicken>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        isChickenJockey(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        setChickenJockey($$0: boolean): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get chickenJockey(): boolean
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set chickenJockey($$0: boolean)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static FOOD_ITEMS: Internal.Ingredient;
        flapSpeed: number;
        eggTime: number;
        flap: number;
        isChickenJockey: boolean;
        oFlapSpeed: number;
        oFlap: number;
        flapping: number;
    }
    type Chicken_ = Chicken;
    class CompoundTag implements Internal.Tag, Internal.NbtCarrier, Internal.NbtCompoundExtensions {
        constructor()
        constructor($$0: Internal.Map_<string, Internal.Tag>)
        getLong($$0: string): number;
        merge($$0: Internal.CompoundTag_): this;
        getLongArray($$0: string): number[];
        getFloat($$0: string): number;
        putShort($$0: string, $$1: number): void;
        putLongArray($$0: string, $$1: number[]): void;
        getTagType($$0: string): number;
        contains($$0: string): boolean;
        sizeInBytes(): number;
        putLongArray($$0: string, $$1: Internal.List_<number>): void;
        getBoolean($$0: string): boolean;
        write($$0: Internal.DataOutput_): void;
        copy(): this;
        getShort($$0: string): number;
        getCompound($$0: string): this;
        accept($$0: Internal.TagVisitor_): void;
        getUUID($$0: string): Internal.UUID;
        getAllKeys(): Internal.Set<string>;
        putByteArray($$0: string, $$1: number[]): void;
        getDouble($$0: string): number;
        putFloat($$0: string, $$1: number): void;
        copy(): Internal.Tag;
        getString($$0: string): string;
        has(key: Internal.NbtKey_<any>): boolean;
        remove($$0: string): void;
        getType(): Internal.TagType<Internal.CompoundTag>;
        accept($$0: Internal.StreamTagVisitor_): Internal.StreamTagVisitor$ValueResult;
        pehkui_getUuid(key: string): Internal.UUID;
        put($$0: string, $$1: Internal.Tag_): Internal.Tag;
        getOr<T>(key: Internal.NbtKey_<T>, defaultValue: T): T;
        getByteArray($$0: string): number[];
        putUUID($$0: string, $$1: Internal.UUID_): void;
        getInt($$0: string): number;
        putByte($$0: string, $$1: number): void;
        isEmpty(): boolean;
        "delete"(key: Internal.NbtKey_<any>): void;
        put(key: Internal.NbtKey_<any>, value: any): void;
        putIntArray($$0: string, $$1: number[]): void;
        mutate<T>(key: Internal.NbtKey_<T>, mutator: Internal.Function_<T, T>): void;
        get($$0: string): Internal.Tag;
        putLong($$0: string, $$1: number): void;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        putByteArray($$0: string, $$1: Internal.List_<number>): void;
        putString($$0: string, $$1: string): void;
        getId(): number;
        putDouble($$0: string, $$1: number): void;
        putIntArray($$0: string, $$1: Internal.List_<number>): void;
        getList($$0: string, $$1: number): Internal.ListTag;
        getIntArray($$0: string): number[];
        copyIfPresent<T>(key: Internal.NbtKey_<T>, other: Internal.NbtCarrier_): void;
        getByte($$0: string): number;
        get(key: Internal.NbtKey_<any>): any;
        copy<T>(key: Internal.NbtKey_<T>, other: Internal.NbtCarrier_): void;
        size(): number;
        getAsString(): string;
        putIfNotNull<T>(key: Internal.NbtKey_<T>, value: T): void;
        hasUUID($$0: string): boolean;
        pehkui_containsUuid(key: string): boolean;
        putBoolean($$0: string, $$1: boolean): void;
        contains($$0: string, $$1: number): boolean;
        putInt($$0: string, $$1: number): void;
        get allKeys(): Internal.Set<string>
        get type(): Internal.TagType<Internal.CompoundTag>
        get empty(): boolean
        get id(): number
        get asString(): string
        static readonly CODEC: Internal.Codec<Internal.CompoundTag>;
        static readonly TYPE: Internal.TagType<Internal.CompoundTag>;
        readonly tags: Internal.Map<string, Internal.Tag>;
    }
    type CompoundTag_ = string | {[key in string]: string|number|boolean|Internal.CompoundTag_} | CompoundTag;
    class BasaltPillarFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type BasaltPillarFeature_ = BasaltPillarFeature;
    class ModParticleTypes$4 extends Internal.SimpleParticleType {
    }
    type ModParticleTypes$4_ = ModParticleTypes$4;
    class ModParticleTypes$3 extends Internal.SimpleParticleType {
    }
    type ModParticleTypes$3_ = ModParticleTypes$3;
    class ModParticleTypes$2 extends Internal.SimpleParticleType {
    }
    type ModParticleTypes$2_ = ModParticleTypes$2;
    class SeedAnalyzerBlock extends Internal.Block implements Internal.EntityBlock {
        constructor()
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly JOURNAL: Internal.BooleanProperty;
    }
    type SeedAnalyzerBlock_ = SeedAnalyzerBlock;
    class ItemPatternAccessTerminalUpgrade extends Internal.ItemUpgrade {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemPatternAccessTerminalUpgrade_ = ItemPatternAccessTerminalUpgrade;
    abstract class BlockEntityConfigurationPacket <BE extends Internal.SyncedBlockEntity> extends Internal.SimplePacketBase {
        constructor(pos: BlockPos_)
        constructor(buffer: Internal.FriendlyByteBuf_)
    }
    type BlockEntityConfigurationPacket_<BE extends Internal.SyncedBlockEntity> = BlockEntityConfigurationPacket<BE>;
    class BlockEntityRenderDispatcher implements Internal.ResourceManagerReloadListener, Internal.AccessorBlockEntityRenderDispatcher {
        constructor($$0: net.minecraft.client.gui.Font_, $$1: Internal.EntityModelSet_, $$2: Internal.Supplier_<Internal.BlockRenderDispatcher>, $$3: Internal.Supplier_<Internal.ItemRenderer>, $$4: Internal.Supplier_<Internal.EntityRenderDispatcher>)
        handler$cac000$entityculling$render(blockEntity: Internal.BlockEntity_, f: number, poseStack: Internal.PoseStack_, multiBufferSource: Internal.MultiBufferSource_, info: Internal.CallbackInfo_): void;
        getRenderer<E extends Internal.BlockEntity>($$0: E): Internal.BlockEntityRenderer<E>;
        hex$getBlockRenderDispatcher(): Internal.Supplier<any>;
        prepare($$0: Internal.Level_, $$1: Internal.Camera_, $$2: Internal.HitResult_): void;
        getName(): string;
        render<E extends Internal.BlockEntity>($$0: E, $$1: number, $$2: Internal.PoseStack_, $$3: Internal.MultiBufferSource_): void;
        onResourceManagerReload($$0: Internal.ResourceManager_): void;
        renderItem<E extends Internal.BlockEntity>($$0: E, $$1: Internal.PoseStack_, $$2: Internal.MultiBufferSource_, $$3: number, $$4: number): boolean;
        setLevel($$0: Internal.Level_): void;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get name(): string
        set level($$0: Internal.Level_)
        renderers: Internal.Map<Internal.BlockEntityType<any>, Internal.BlockEntityRenderer<any>>;
        camera: Internal.Camera;
        level: Internal.Level;
        cameraHitResult: Internal.HitResult;
    }
    type BlockEntityRenderDispatcher_ = BlockEntityRenderDispatcher;
    class WanderingTrader extends Internal.AbstractVillager {
        constructor($$0: Internal.EntityType_<Internal.WanderingTrader>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        method_5992($$0: Internal.Player_, $$1: Internal.InteractionHand_): Internal.InteractionResult;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        setDespawnDelay($$0: number): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        static pickUpItem($$0: Internal.Mob_, $$1: Internal.InventoryCarrier_, $$2: Internal.ItemEntity_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        readInventoryFromTag($$0: Internal.CompoundTag_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        handler$ddk001$hexical$addNewTrades(info: Internal.CallbackInfo_): void;
        writeInventoryToTag($$0: Internal.CompoundTag_): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getDespawnDelay(): number;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        openTradingScreen($$0: Internal.Player_, $$1: net.minecraft.network.chat.Component_, $$2: number): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        setWanderTarget($$0: BlockPos_): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        canRestock(): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        set despawnDelay($$0: number)
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get despawnDelay(): number
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        set wanderTarget($$0: BlockPos_)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type WanderingTrader_ = WanderingTrader;
    interface StorageCell extends Internal.MEStorage {
        canFitInsideCell(): boolean;
        getAvailableStacks(out: Internal.KeyCounter_): void;
        checkPreconditions(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): void;
        isPreferredStorageFor(what: Internal.AEKey_, source: Internal.IActionSource_): boolean;
        abstract getIdleDrain(): number;
        abstract persist(): void;
        getAvailableStacks(): Internal.KeyCounter;
        extract(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): number;
        insert(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): number;
        abstract getStatus(): Internal.CellState;
        abstract getDescription(): net.minecraft.network.chat.Component;
        get idleDrain(): number
        get availableStacks(): Internal.KeyCounter
        get status(): Internal.CellState
        get description(): net.minecraft.network.chat.Component
    }
    type StorageCell_ = StorageCell;
    class FabricEntityTypeBuilder <T extends Internal.Entity> {
        static createLiving<T extends Internal.LivingEntity>(): Internal.FabricEntityTypeBuilder$Living<T>;
        entityFactory<N extends T>(factory: Internal.EntityType$EntityFactory_<N>): Internal.FabricEntityTypeBuilder<N>;
        static create<T extends Internal.Entity>(spawnGroup: Internal.MobCategory_): Internal.FabricEntityTypeBuilder<T>;
        specificSpawnBlocks(...blocks: Internal.Block_[]): this;
        static createMob<T extends Internal.Mob>(): Internal.FabricEntityTypeBuilder$Mob<T>;
        disableSummon(): this;
        trackRangeChunks(range: number): this;
        trackRangeBlocks(range: number): this;
        spawnableFarFromPlayer(): this;
        forceTrackedVelocityUpdates(forceTrackedVelocityUpdates: boolean): this;
        trackedUpdateRate(rate: number): this;
        /**
         * @deprecated
        */
        trackable(trackRangeBlocks: number, trackedUpdateRate: number): this;
        requires(...requiredFeatures: Internal.FeatureFlag_[]): this;
        /**
         * @deprecated
        */
        trackable(trackRangeBlocks: number, trackedUpdateRate: number, forceTrackedVelocityUpdates: boolean): this;
        build(): Internal.EntityType<T>;
        spawnGroup(group: Internal.MobCategory_): this;
        disableSaving(): this;
        dimensions(dimensions: Internal.EntityDimensions_): this;
        fireImmune(): this;
        static create<T extends Internal.Entity>(spawnGroup: Internal.MobCategory_, factory: Internal.EntityType$EntityFactory_<T>): Internal.FabricEntityTypeBuilder<T>;
        static create<T extends Internal.Entity>(): Internal.FabricEntityTypeBuilder<T>;
    }
    type FabricEntityTypeBuilder_<T extends Internal.Entity> = FabricEntityTypeBuilder<T>;
    class QuickPlayLog {
        static of($$0: string): Internal.QuickPlayLog;
        setWorldData($$0: Internal.QuickPlayLog$Type_, $$1: string, $$2: string): void;
        log($$0: Internal.Minecraft_): void;
    }
    type QuickPlayLog_ = QuickPlayLog;
    class BeaconBlockEntity$BeaconBeamSection {
        constructor($$0: number[])
        getColor(): number[];
        getHeight(): number;
        get color(): number[]
        get height(): number
    }
    type BeaconBlockEntity$BeaconBeamSection_ = BeaconBlockEntity$BeaconBeamSection;
    class MagnetUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.MagnetUpgradeWrapper, Internal.MagnetUpgradeItem> implements Internal.IPickupResponseUpgrade, Internal.ITickableUpgrade, Internal.IContentsFilteredUpgrade {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        shouldPickupItems(): boolean;
        canBeDisabled(): boolean;
        shouldPickupXp(): boolean;
        getFilterLogic(): Internal.ContentsFilterLogic;
        hideSettingsTab(): boolean;
        setPickupItems(pickupItems: boolean): void;
        static addMagnetPreventionChecker(checker: Internal.IMagnetPreventionChecker_): void;
        tick(entity: Internal.Entity_, world: Internal.Level_, pos: BlockPos_): void;
        pickup(world: Internal.Level_, stack: Internal.ItemStack_, ctx: Internal.TransactionContext_): Internal.ItemStack;
        onAdded(): void;
        setPickupXp(pickupXp: boolean): void;
        onBeforeRemoved(): void;
        get filterLogic(): Internal.ContentsFilterLogic
        set pickupItems(pickupItems: boolean)
        set pickupXp(pickupXp: boolean)
    }
    type MagnetUpgradeWrapper_ = MagnetUpgradeWrapper;
    class MethodResult {
        getErrorAdjust(): number;
        static of(...values: any[]): Internal.MethodResult;
        getResult(): any[];
        static of(): Internal.MethodResult;
        static of(value: any): Internal.MethodResult;
        static pullEventRaw(filter: string, callback: Internal.ILuaCallback_): Internal.MethodResult;
        static "yield"(arguments_: any[], callback: Internal.ILuaCallback_): Internal.MethodResult;
        adjustError(adjust: number): this;
        static pullEvent(filter: string, callback: Internal.ILuaCallback_): Internal.MethodResult;
        getCallback(): Internal.ILuaCallback;
        get errorAdjust(): number
        get result(): any[]
        get callback(): Internal.ILuaCallback
    }
    type MethodResult_ = MethodResult;
    abstract class BaseRailBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock, Internal.BaseRailBlockExtensions {
        static isRail($$0: Internal.BlockState_): boolean;
        static isRail($$0: Internal.Level_, $$1: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getRailDirection(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, cart: Internal.BaseRailBlock_): Internal.RailShape;
        isStraight(): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        abstract getShapeProperty(): Internal.Property<Internal.RailShape>;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get straight(): boolean
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get shapeProperty(): Internal.Property<Internal.RailShape>
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type BaseRailBlock_ = BaseRailBlock;
    class TinkersChestBlockItem extends Internal.BlockItem implements Internal.DyeableLeatherItem {
        constructor(blockIn: Internal.Block_, builder: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getColor(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        hasCustomColor($$0: Internal.ItemStack_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static dyeArmor($$0: Internal.ItemStack_, $$1: Internal.List_<Internal.DyeItem>): Internal.ItemStack;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setColor($$0: Internal.ItemStack_, $$1: number): void;
        emi(amount: number): Internal.EmiStack;
        clearColor($$0: Internal.ItemStack_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type TinkersChestBlockItem_ = TinkersChestBlockItem;
    class ModParticleTypes$1 extends Internal.SimpleParticleType {
    }
    type ModParticleTypes$1_ = ModParticleTypes$1;
    class SeveringRecipe implements Internal.ICustomOutputRecipe<Internal.IEmptyContainer> {
        constructor(id: ResourceLocation_, ingredient: any_, output: any_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        /**
         * @deprecated
        */
        matches(inv: Internal.IEmptyContainer_, worldIn: Internal.Level_): boolean;
        matches(type: Internal.EntityType_<any>): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        /**
         * @deprecated
        */
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getItemInputs(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        assemble(inv: Internal.IEmptyContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        getOutput(): Internal.ItemStack;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getEntityInputs(): Internal.List<Internal.EntityType<any>>;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getOutput(entity: Internal.Entity_): Internal.ItemStack;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getRemainingItems($$0: Internal.IEmptyContainer_): Internal.NonNullList<Internal.ItemStack>;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get itemInputs(): Internal.List<Internal.ItemStack>
        get mod(): string
        get output(): Internal.ItemStack
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get entityInputs(): Internal.List<Internal.EntityType<any>>
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type SeveringRecipe_ = SeveringRecipe;
    class DiskFeature extends Internal.Feature<Internal.DiskConfiguration> {
        constructor($$0: Internal.Codec_<Internal.DiskConfiguration>)
    }
    type DiskFeature_ = DiskFeature;
    class BrushableBlock extends Internal.BaseEntityBlock implements Internal.Fallable {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_, $$2: Internal.SoundEvent_, $$3: Internal.SoundEvent_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBrushCompletedSound(): Internal.SoundEvent;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        onLand($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.FallingBlockEntity_): void;
        setRequiresTool(v: boolean): void;
        onBrokenAfterFall($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FallingBlockEntity_): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getTurnsInto(): Internal.Block;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFallDamageSource($$0: Internal.Entity_): DamageSource;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getBrushSound(): Internal.SoundEvent;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        get brushCompletedSound(): Internal.SoundEvent
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get turnsInto(): Internal.Block
        set destroySpeed(v: number)
        get brushSound(): Internal.SoundEvent
        static readonly TICK_DELAY: 2;
    }
    type BrushableBlock_ = BrushableBlock;
    interface ICustomPickBlock {
        abstract getPickBlock(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        (arg0: Internal.BlockState, arg1: Internal.HitResult, arg2: Internal.BlockGetter, arg3: BlockPos, arg4: Internal.Player): Internal.ItemStack_;
    }
    type ICustomPickBlock_ = ICustomPickBlock;
    interface LightChunkGetter {
        abstract getChunkForLighting(arg0: number, arg1: number): Internal.LightChunk;
        abstract getLevel(): Internal.BlockGetter;
        onLightUpdate($$0: Internal.LightLayer_, $$1: Internal.SectionPos_): void;
        get level(): Internal.BlockGetter
    }
    type LightChunkGetter_ = LightChunkGetter;
    class SpecialRecipeSerializerManager extends Internal.EventJS {
        constructor()
        isSpecial(recipe: Internal.Recipe_<any>): boolean;
        ignoreSpecialMod(modid: string): void;
        ignoreSpecialFlag(id: ResourceLocation_): void;
        addSpecialMod(modid: string): void;
        reset(): void;
        addSpecialFlag(id: ResourceLocation_): void;
        static readonly INSTANCE: Internal.SpecialRecipeSerializerManager;
        static readonly EVENT: dev.architectury.event.Event<Internal.Runnable>;
    }
    type SpecialRecipeSerializerManager_ = SpecialRecipeSerializerManager;
    class ServerboundSetBeaconPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.Optional_<Internal.MobEffect>, $$1: Internal.Optional_<Internal.MobEffect>)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getSecondary(): Internal.Optional<Internal.MobEffect>;
        getPrimary(): Internal.Optional<Internal.MobEffect>;
        isSkippable(): boolean;
        get secondary(): Internal.Optional<Internal.MobEffect>
        get primary(): Internal.Optional<Internal.MobEffect>
        get skippable(): boolean
    }
    type ServerboundSetBeaconPacket_ = ServerboundSetBeaconPacket;
    class ModifierRepairRecipeSerializer <T extends Internal.Recipe<any> & Internal.ModifierRepairRecipeSerializer$IModifierRepairRecipe> extends Internal.LoggingRecipeSerializer<T> {
        constructor(factory: any_<T>)
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): T;
    }
    type ModifierRepairRecipeSerializer_<T extends Internal.Recipe<any> & Internal.ModifierRepairRecipeSerializer$IModifierRepairRecipe> = ModifierRepairRecipeSerializer<T>;
    class ExtraCodecs$TagOrElementLocation extends Internal.Record {
        constructor($$0: ResourceLocation_, $$1: boolean)
        tag(): boolean;
        id(): ResourceLocation;
        decoratedId(): string;
    }
    type ExtraCodecs$TagOrElementLocation_ = ExtraCodecs$TagOrElementLocation;
    class DataResult$PartialResult <R> {
        constructor(arg0: Internal.Supplier_<string>, arg1: Internal.Optional_<R>)
        message(): string;
        map<R2>(arg0: Internal.Function_<R, R2>): Internal.DataResult$PartialResult<R2>;
        flatMap<R2>(arg0: Internal.Function_<R, Internal.DataResult$PartialResult<R2>>): Internal.DataResult$PartialResult<R2>;
    }
    type DataResult$PartialResult_<R> = DataResult$PartialResult<R>;
    class WeatheringCopperStairBlock extends Internal.StairBlock implements Internal.WeatheringCopper {
        constructor($$0: Internal.WeatheringCopper$WeatherState_, $$1: Internal.BlockState_, $$2: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static invokeGetStairShape(state: Internal.BlockState_, worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.StairsShape;
        getBlockStates(): Internal.List<Internal.BlockState>;
        applyChangeOverTime($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getAge(): Internal.WeatheringCopper$WeatherState;
        getNext($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        static getPrevious($$0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        onRandomTick($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static getPrevious($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getAge(): Internal.Enum<any>;
        setDestroySpeed(v: number): void;
        static getFirst($$0: Internal.Block_): Internal.Block;
        static getNext($$0: Internal.Block_): Internal.Optional<Internal.Block>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getFirst($$0: Internal.BlockState_): Internal.BlockState;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getChanceModifier(): number;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get age(): Internal.WeatheringCopper$WeatherState
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get age(): Internal.Enum<any>
        set destroySpeed(v: number)
        get chanceModifier(): number
    }
    type WeatheringCopperStairBlock_ = WeatheringCopperStairBlock;
    interface SimpleRegistry$Provider <K, V> {
        forBlockTag<V>(tag: Internal.TagKey_<Internal.Block>, value: V): Internal.SimpleRegistry$Provider<Internal.Block, V>;
        forItemTag<V>(tag: Internal.TagKey_<Internal.Item>, value: V): Internal.SimpleRegistry$Provider<Internal.Item, V>;
        forEntityTag<V>(tag: Internal.TagKey_<Internal.EntityType<any>>, value: V): Internal.SimpleRegistry$Provider<Internal.EntityType<any>, V>;
        forBlockEntityTag<V>(tag: Internal.TagKey_<Internal.BlockEntityType<any>>, value: V): Internal.SimpleRegistry$Provider<Internal.BlockEntityType<any>, V>;
        onRegister(invalidate: Internal.Runnable_): void;
        abstract get(arg0: K): V;
        forTag<K, V>(tag: Internal.TagKey_<K>, holderGetter: Internal.Function_<K, Internal.Holder<K>>, value: V): this;
        forFluidTag<V>(tag: Internal.TagKey_<Internal.Fluid>, value: V): Internal.SimpleRegistry$Provider<Internal.Fluid, V>;
        (arg0: K): V;
    }
    type SimpleRegistry$Provider_<K, V> = SimpleRegistry$Provider<K, V>;
    class WeakHashMap <K, V> extends Internal.AbstractMap<K, V> implements Internal.Map<K, V> {
        constructor(arg0: Internal.Map_<K, V>)
        constructor()
        constructor(arg0: number)
        constructor(arg0: number, arg1: number)
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        static newWeakHashMap<K, V>(arg0: number): Internal.WeakHashMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type WeakHashMap_<K, V> = WeakHashMap<K, V>;
    class WeightedListInt extends Internal.IntProvider {
        constructor($$0: Internal.SimpleWeightedRandomList_<Internal.IntProvider>)
        static readonly CODEC: Internal.Codec<Internal.WeightedListInt>;
    }
    type WeightedListInt_ = WeightedListInt;
    class CompactingUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.CompactingUpgradeWrapper, Internal.CompactingUpgradeItem> implements Internal.IFilteredUpgrade, Internal.ISlotChangeResponseUpgrade, Internal.IInsertResponseUpgrade, Internal.ITickableUpgrade {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        shouldCompactNonUncraftable(): boolean;
        tick(entity: Internal.Entity_, world: Internal.Level_, pos: BlockPos_): void;
        onSlotChange(inventoryHandler: Internal.SlottedStackStorage_, slot: number): void;
        getFilterLogic(): Internal.FilterLogic;
        canBeDisabled(): boolean;
        onAfterInsert(inventoryHandler: Internal.IItemHandlerSimpleInserter_, slot: number, ctx: Internal.TransactionContext_): void;
        hideSettingsTab(): boolean;
        onBeforeInsert(inventoryHandler: Internal.IItemHandlerSimpleInserter_, slot: number, resource: Internal.ItemVariant_, maxAmount: number, ctx: Internal.TransactionContext_): number;
        setShouldWorkdInGUI(shouldWorkdInGUI: boolean): void;
        setCompactNonUncraftable(shouldCompactNonUncraftable: boolean): void;
        shouldWorkInGUI(): boolean;
        onAdded(): void;
        onBeforeRemoved(): void;
        get filterLogic(): Internal.FilterLogic
        set shouldWorkdInGUI(shouldWorkdInGUI: boolean)
        set compactNonUncraftable(shouldCompactNonUncraftable: boolean)
    }
    type CompactingUpgradeWrapper_ = CompactingUpgradeWrapper;
    class ItemArtifact extends Internal.ItemPackagedHex implements Internal.VariantItem {
        constructor(pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        getVariant(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        setVariant(stack: Internal.ItemStack_, variant: number): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getMediaFullness(stack: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        clampVariant(variant: number): number;
        numVariants(): number;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemArtifact_ = ItemArtifact;
    class ElytraItem extends Internal.Item implements Internal.Equipable {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        static isFlyEnabled($$0: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getEquipSound(): Internal.SoundEvent;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getEquipmentSlot(): Internal.EquipmentSlot;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get equipmentSlot(): Internal.EquipmentSlot
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ElytraItem_ = ElytraItem;
    class FuelTankMountedStorage extends Internal.WrapperMountedFluidStorage<any> implements Internal.SyncedMountedStorage {
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        markClean(): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.FluidVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        getFluid(): Internal.FluidStack;
        afterSync(contraption: Internal.Contraption_, localPos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.FluidVariant_): Internal.StorageView<Internal.FluidVariant>;
        isDirty(): boolean;
        static asClass<T>(): Internal.Storage<T>;
        static fromLegacy(nbt: Internal.CompoundTag_): Internal.FuelTankMountedStorage;
        static fromTank(tank: Internal.FuelTankBlockEntity_): Internal.FuelTankMountedStorage;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        static empty<T>(): Internal.Storage<T>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        getCapacity(): number;
        get fluid(): Internal.FluidStack
        get dirty(): boolean
        get capacity(): number
        static readonly CODEC: Internal.Codec<Internal.FuelTankMountedStorage>;
    }
    type FuelTankMountedStorage_ = FuelTankMountedStorage;
    class Tutorial {
        constructor($$0: Internal.Minecraft_, $$1: Internal.Options_)
        setStep($$0: Internal.TutorialSteps_): void;
        onMouse($$0: number, $$1: number): void;
        getMinecraft(): Internal.Minecraft;
        isSurvival(): boolean;
        addTimedToast($$0: Internal.TutorialToast_, $$1: number): void;
        onInventoryAction($$0: Internal.ItemStack_, $$1: Internal.ItemStack_, $$2: Internal.ClickAction_): void;
        onOpenInventory(): void;
        tick(): void;
        static key($$0: string): net.minecraft.network.chat.Component;
        removeTimedToast($$0: Internal.TutorialToast_): void;
        start(): void;
        onDestroyBlock($$0: Internal.ClientLevel_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: number): void;
        stop(): void;
        onLookAt($$0: Internal.ClientLevel_, $$1: Internal.HitResult_): void;
        onInput($$0: Internal.Input_): void;
        onGetItem($$0: Internal.ItemStack_): void;
        set step($$0: Internal.TutorialSteps_)
        get minecraft(): Internal.Minecraft
        get survival(): boolean
    }
    type Tutorial_ = Tutorial;
    class ModularAccumulatorDisplaySource extends Internal.PercentOrProgressBarDisplaySource {
        constructor()
    }
    type ModularAccumulatorDisplaySource_ = ModularAccumulatorDisplaySource;
    class OrientableSmelteryBlock extends Internal.SearedBlock implements Internal.EntityBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, blockEntity: any_<any>)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type OrientableSmelteryBlock_ = OrientableSmelteryBlock;
    /**
     * Invoked when a player opens or closes a container.
    */
    class InventoryEventJS extends Internal.PlayerEventJS {
        constructor(player: Internal.Player_, menu: Internal.AbstractContainerMenu_)
        /**
         * Gets the player that opened or closed the container.
        */
        getEntity(): Internal.LivingEntity;
        /**
         * Gets the container that was opened or closed.
        */
        getInventoryContainer(): Internal.AbstractContainerMenu;
        /**
         * Gets the player that opened or closed the container.
        */
        get entity(): Internal.LivingEntity
        /**
         * Gets the container that was opened or closed.
        */
        get inventoryContainer(): Internal.AbstractContainerMenu
    }
    type InventoryEventJS_ = InventoryEventJS;
    interface ChestMenuClickEvent$Callback {
        abstract onClick(arg0: Internal.ChestMenuClickEvent_): void;
        (arg0: Internal.ChestMenuClickEvent): void;
    }
    type ChestMenuClickEvent$Callback_ = ChestMenuClickEvent$Callback;
    class RedstoneContactBlock extends Internal.WrenchableDirectionalBlock implements Internal.WeakPowerCheckingBlock, Internal.ConnectableRedstoneBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static hasValidContact(world: Internal.LevelAccessor_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        shouldCheckWeakPower(state: Internal.BlockState_, level: Internal.SignalGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly POWERED: Internal.BooleanProperty;
    }
    type RedstoneContactBlock_ = RedstoneContactBlock;
    class XpPumpUpgradeItem extends Internal.UpgradeItemBase<Internal.XpPumpUpgradeWrapper> {
        constructor(xpPumpUpgradeConfig: Internal.XpPumpUpgradeConfig_, upgradeTypeLimitConfig: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        getXpPumpUpgradeConfig(): Internal.XpPumpUpgradeConfig;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        getType(): Internal.UpgradeType<Internal.XpPumpUpgradeWrapper>;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get xpPumpUpgradeConfig(): Internal.XpPumpUpgradeConfig
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get type(): Internal.UpgradeType<Internal.XpPumpUpgradeWrapper>
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.XpPumpUpgradeWrapper>;
    }
    type XpPumpUpgradeItem_ = XpPumpUpgradeItem;
    abstract class AbstractBellBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        ring(world: Internal.Level_, pos: BlockPos_, direction: Internal.Direction_): boolean;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        abstract getBellModel(): Internal.PartialModel;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        get bellModel(): Internal.PartialModel
        ringingTicks: number;
        ringDirection: Internal.Direction;
        static readonly RING_DURATION: 74;
        isRinging: boolean;
    }
    type AbstractBellBlockEntity_ = AbstractBellBlockEntity;
    class TrackCouplerBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity, Internal.IHaveGoggleInformation {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getSecondaryCoupler(): Internal.TrackCoupler;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        getCoupler(): Internal.TrackCoupler;
        areEdgePointsOk(): boolean;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getEdgeSpacing(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTargetAnalogOutput(): number;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        getClientInfo(): Internal.TrackCouplerBlockEntity$ClientInfo;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        getOperationInfo(): Internal.TrackCouplerBlockEntity$OperationInfo;
        setClientInfo(info: Internal.TrackCouplerBlockEntity$ClientInfo_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(blockEntity: Internal.BlockEntity_, structureTransform: Internal.StructureTransform_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getOperationMode(): Internal.TrackCouplerBlockEntity$OperationMode;
        getReportedPower(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getAllowedOperationMode(): Internal.TrackCouplerBlockEntity$AllowedOperationMode;
        get secondaryCoupler(): Internal.TrackCoupler
        get coupler(): Internal.TrackCoupler
        get edgeSpacing(): number
        get targetAnalogOutput(): number
        get clientInfo(): Internal.TrackCouplerBlockEntity$ClientInfo
        get infiniteBoundingBox(): Internal.AABB
        get operationInfo(): Internal.TrackCouplerBlockEntity$OperationInfo
        set clientInfo(info: Internal.TrackCouplerBlockEntity$ClientInfo_)
        get operationMode(): Internal.TrackCouplerBlockEntity$OperationMode
        get reportedPower(): boolean
        get allowedOperationMode(): Internal.TrackCouplerBlockEntity$AllowedOperationMode
        secondEdgePoint: Internal.TrackTargetingBehaviour<Internal.TrackCoupler>;
        edgePoint: Internal.TrackTargetingBehaviour<Internal.TrackCoupler>;
    }
    type TrackCouplerBlockEntity_ = TrackCouplerBlockEntity;
    class HammockBlock extends Internal.BaseComfortsBlock {
        constructor(color: Internal.DyeColor_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static dropRopeSupport(pos: BlockPos_, direction: Internal.Direction_, isHead: boolean, level: Internal.Level_): void;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        static getDirectionToOther(part: Internal.BedPart_, facing: Internal.Direction_): Internal.Direction;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type HammockBlock_ = HammockBlock;
}
declare namespace javax.swing {
    interface Icon {
        abstract getIconHeight(): number;
        abstract paintIcon(arg0: Internal.Component_, arg1: Internal.Graphics_, arg2: number, arg3: number): void;
        abstract getIconWidth(): number;
        get iconHeight(): number
        get iconWidth(): number
    }
    type Icon_ = Icon;
}
